#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	


	[TestFixture]
	public class BOL_InventoryItem : BaseTest 
	{
		private BOL.InventoryItem _tstII;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			_tstII = new BOL.InventoryItem();
		}

		[Test]
		public void Ctor_Pass()
		{			
			Assert.IsNotNull(_tstII);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{			
		}

		[Test]
		public void CannedComment_Pass()
		{
			_tstII.CannedComment = new CannedComment(System.Guid.NewGuid());
			BOL.CannedComment _cannedComment = _tstII.CannedComment;
			Assert.AreEqual(_tstII.CannedComment,_cannedComment);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CannedComment_Fail()
		{
		}

		[Test]
		public void Inspection_Pass()
		{
			Array inspectionTypes = Enum.GetValues(typeof(Common.Inspection));

			foreach (Common.Inspection inspectionType in inspectionTypes)
			{
				_tstII.Inspection = inspectionType;
				Common.Inspection _inspection = _tstII.Inspection;
				Assert.AreEqual(_tstII.Inspection,_inspection);
			}
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void Inspection_Fail()
		{		
			_tstII.Inspection = (Common.Inspection) 4;			
		}

		[Test]
		public void InvoiceNumber_Pass()
		{
			_tstII.InvoiceNumber = string.Empty.PadRight(20, 'X');
			string _InvoiceNumber = _tstII.InvoiceNumber;
			Assert.AreEqual(_tstII.InvoiceNumber,_InvoiceNumber);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvoiceNumber_Fail()
		{
		}


		[Test]
		public void ManufacturerName_Pass()
		{
			_tstII.ManufacturerName= string.Empty.PadRight(20, 'X');
			string _ManufacturerName = _tstII.ManufacturerName;
			Assert.AreEqual(_tstII.ManufacturerName,_ManufacturerName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ManufacturerName_Fail()
		{
		}

		[Test]
		public void TypeID_Pass()
		{
			_tstII.TypeID= int.MaxValue;
			int _TypeID = _tstII.TypeID;
			Assert.AreEqual(_tstII.TypeID,_TypeID);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TypeID_Fail()
		{
		}


		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable dtTest = new DataTable();

			DataRow dr1 = dtTest.NewRow();

			DataRow dr2 = this._tstII.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1,dr2);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}



	}
}
#endif


